using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using System.Collections;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///	The class implements data persistence logic for blood unit antigens (BOL.BloodUnitAntigen).
		///	It provides static methods to retrieve and save blood unit antigens data.
		///</summary>

		#endregion

	public class BloodUnitAntigen
	{



		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="636"> 
		///		<ExpectedInput>Blood unit identifier and division code</ExpectedInput>
		///		<ExpectedOutput>The data table containing existing antigen results for a given blood unit</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1893"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves existing antigen results for a given blood unit 
		/// identified by blood unit GUID and division code.
		/// </summary>
		/// <param name="bloodUnitGuidList">Blood unit GUID list</param>
		/// <param name="divisionCode">Division code</param>
		/// <returns>DataTable of blood unit antigens</returns>
		//public static DataTable GetBloodUnitAntigens( Guid bloodUnitGuid, string divisionCode )
		public static DataTable GetBloodUnitAntigens( string bloodUnitGuidList, string divisionCode )
		{
			SqlParameter[] prms = 
				{
					Common.StoredProcedure.MakeParameter(STOREDPROC.GetBloodUnitAntigens.bloodunitguidlist,bloodUnitGuidList),
					Common.StoredProcedure.MakeParameter(STOREDPROC.GetBloodUnitAntigens.divisioncode,divisionCode)
				};

			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetBloodUnitAntigens.StoredProcName, prms);

			return ds.Tables[0] ;
		}

		///<Case type="0" testid ="8373"> 
		///		<ExpectedInput>Valid bloodunitguid, valid antigentypeid</ExpectedInput>
		///		<ExpectedOutput>a data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8374"> 
		///		<ExpectedInput>invalid bloodunitguid, invalid antigentypeid</ExpectedInput>
		///		<ExpectedOutput>empty datatable</ExpectedOutput>
		///	</Case>
		///
		///
		///
		/// <summary>
		/// Retrieves existing antigen results for a given blood unit 
		/// identified by blood unit GUID and antigenTypeID
		/// </summary>
		/// <param name="bloodUnitGuid">Blood unit GUID</param>
		/// <param name="antigenTypeID">antigenTypeID</param>
		/// <returns>DataTable of blood unit antigens</returns>
		public static DataTable GetBloodUnitAntigenByGuidAndID( Guid bloodUnitGuid, int antigenTypeID )
		{
			SqlParameter[] prms = 
				{
					Common.StoredProcedure.MakeParameter(STOREDPROC.GetBloodAntigenByGuidAndID.bloodunitguid,bloodUnitGuid),
					Common.StoredProcedure.MakeParameter(STOREDPROC.GetBloodAntigenByGuidAndID.antigentypeid,antigenTypeID)
				};

			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetBloodAntigenByGuidAndID.StoredProcName, prms);

			return ds.Tables[0] ;
		}
		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/21/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5015"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>Datatable with Antigen information</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5016"> 
		///		<ExpectedInput>Invalid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves existing antigen results for a given blood unit 
		/// identified by blood unit GUID and division code.  This 
		/// version gets both active and inactive antigens for the 
		/// given blood unit guid.
		/// </summary>
		/// <param name="bloodUnitGuid">Blood unit GUID</param>
		/// <param name="divisionCode">Division code</param>
		/// <returns>DataTable of blood unit antigens</returns>
		public static DataTable GetAllAntigensForBloodUnit( Guid bloodUnitGuid, string divisionCode )
		{
			SqlParameter[] prms = 
				{
					Common.StoredProcedure.MakeParameter(STOREDPROC.GetAllAntigensForBloodUnit.bloodunitguid,bloodUnitGuid),
					Common.StoredProcedure.MakeParameter(STOREDPROC.GetAllAntigensForBloodUnit.divisioncode,divisionCode)
				};

			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetAllAntigensForBloodUnit.StoredProcName, prms);

			return ds.Tables[0] ;
		}
	}
}

